<?php

require_once 'includes/controllers/base.php';
require_once 'includes/models/article.php';
require_once 'includes/models/user.php';
require_once 'includes/models/comment.php';

class AdminController extends BaseController {
  private $articleModel;
  private $userModel;
  private $commentModel;

  public function __construct($db) {
    parent::__construct($db);
    $this->articleModel = new Article($db);
    $this->userModel = new User($db);
    $this->commentModel = new Comment($db);
  }

  public function list() {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    $articles = $this->articleModel->getAll();
    $users = $this->userModel->getAll();
    $this->render(
      'includes/views/admin/index.php',
      'Administration',
      ['articles' => $articles, 'users' => $users]
    );
  }

  public function edit_article($id) {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      if (isset($_POST['id_billet'])) {
        $this->articleModel->update($_POST['id_billet'], $_POST);
      } else {
        $this->articleModel->create($_POST);
      }
      header('Location: index.php?page=admin');
    } else {
      $data = [];
      if ($id) {
        $article = $this->articleModel->getById($id);
        $comments = $this->commentModel->getAllForArticle($id);
        $data['comments'] = $comments;
        $data['article'] = $article;
      }
      $this->render('includes/views/admin/article.php', 'Article', $data);
    }
  }

  public function edit_user($id) {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      if (isset($_POST['id_utilisateur'])) {
        $this->userModel->update($_POST['id_utilisateur'], $_POST);
      } else {
        $this->userModel->create($_POST);
      }
      header('Location: index.php?page=admin');
    } else {
      $data = [];
      if ($id) {
        $user = $this->userModel->getById($id);
        $data['user'] = $user;
      }
      $this->render('includes/views/admin/user.php', 'Utilisateur', $data);
    }
  }

  public function delete_article($id) {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    $this->articleModel->delete($id);
    header('Location: index.php?page=admin');
  }

  public function delete_user($id) {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    $this->userModel->delete($id);
    header('Location: index.php?page=admin');
  }

  public function delete_comment($id) {
    if (!$this->loggedUser || $this->loggedUser['admin'] !== "1") {
      $this->forbidden();
      return;
    }
    $comment = $this->commentModel->getById($id);
    $this->commentModel->delete($id);
    header('Location: index.php?page=admin&action=edit_article&id=' . $comment['id_billet']);
  }

  public function forbidden() {
    header('HTTP/1.0 403 Forbidden');
    $this->render('includes/views/admin/forbidden.php', 'Accès interdit');
  }
}
