<?php

require_once 'includes/controllers/base.php';
require_once 'includes/models/article.php';
require_once 'includes/models/comment.php';

class ArticlesController extends BaseController {
  private $articleModel;

  public function __construct($db) {
    parent::__construct($db);
    $this->articleModel = new Article($db);
  }

  public function list() {
    $billets = $this->articleModel->getLasts();
    $this->render(
      'includes/views/articles/index.php',
      'Bienvenue sur mon blog',
      ['billets' => $billets]
    );
  }

  public function archives() {
    $billets = $this->articleModel->getAll();
    $this->render(
      'includes/views/articles/index.php',
      'Archives',
      ['billets' => $billets]
    );
  }

  public function display($id) {
    $referringUrl = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'index.php?page=articles';
    $article = $this->articleModel->getById($id);
    $this->render(
      'includes/views/articles/article.php',
      $article['titre'],
      ['article' => $article, 'referer' => $referringUrl]
    );
  }
}