<?php

class BaseController {
  protected $db;
  protected $loggedUser;

  public function __construct($db) {
    $this->db = $db;
    $this->loggedUser = $this->getLoggedUser();
  }

  protected function getLoggedUser() {
    if (isset($_SESSION['id_utilisateur'])) {
      $userModel = new User($this->db);
      return $userModel->getById($_SESSION['id_utilisateur']);
    }
    return null;
  }

  protected function render($view, $title, $data = []) {
    extract($data); // transforme les clés du tableau associatif en variables
    $loggedUser = $this->loggedUser;
    require 'includes/views/header.php';
    require $view;
    require 'includes/views/footer.php';
  }
}
