<?php

require_once 'includes/controllers/base.php';
require_once 'includes/models/comment.php';

class CommentsController extends BaseController {
  private $commentModel;

  public function __construct($db) {
    parent::__construct($db);
    $this->commentModel = new Comment($db);
  }

  public function json_list($id_billet) {
    $comments = $this->commentModel->getAllForArticle($id_billet);
    header('Content-Type: application/json');
    echo json_encode($comments);
  }

  public function json_add() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      $id = $this->commentModel->create($_POST);
      $comment = $this->commentModel->getById($id);
      header('Content-Type: application/json');
      echo json_encode($comment);
    } else {
      header('Location: index.php?page=articles');
    }
  }
}