<?php

require_once 'includes/controllers/base.php';
require_once 'includes/models/user.php';

class UsersController extends BaseController {
    private $userModel;

    public function __construct($db) {
        parent::__construct($db);
        $this->userModel = new User($db);
    }

    public function register() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // verification des données
            // mots de passes mdp_confirm et mdp identiques
            if ($_POST['mdp'] !== $_POST['mdp_confirm']) {
                $error = "Les mots de passe ne correspondent pas";
                $this->render('includes/views/users/register.php', "S'inscrire", ['error' => $error]);
                return;
            }
            $photo = $_FILES['photo'];
            if ($photo['error'] === 0) {
              if ($photo['size'] > 5 * 1024 * 1024) {
                $error = "La taille de la photo ne doit pas dépasser 5Mo";
                $this->render('includes/views/users/register.php', "S'inscrire", ['error' => $error]);
                return;
              }
              $image_file = $photo['tmp_name'];
              $photo = 'data:' . mime_content_type($image_file) . ';base64,' . base64_encode(file_get_contents($image_file));
            } else {
                $photo = NULL;
            }
            $_SESSION['id_utilisateur'] = $this->userModel->create($_POST, $photo);
            header('Location: index.php');
        } else {
            $this->render('includes/views/users/register.php', "S'inscrire");
        }
    }

    public function login() {
      if ($_SERVER['REQUEST_METHOD'] === 'POST') {
          $user = $this->userModel->getByLogin($_POST['login']);
          if ($user && password_verify($_POST['mdp'], $user['mdp'])) {
              $_SESSION['id_utilisateur'] = $user['id_utilisateur'];
              header('Location: index.php');
          } else {
              $error = "Login ou mot de passe incorrect";
              $this->render('includes/views/users/login.php', 'Connexion', ['error' => $error]);
          }
      } else {
        $this->render('includes/views/users/login.php', 'Connexion');
      }
    }

    public function logout() {
      session_destroy();
      header('Location: index.php');
  }
}
