<?php

class Article {
  private $db;
  static $FETCH_ALL_QUERY = "
    SELECT 
        b.id_billet, b.titre, b.contenu, b.date_creation,
        u.id_utilisateur, u.login, u.nom, u.prenom
    FROM billets b
    LEFT JOIN utilisateurs u ON b.id_utilisateur = u.id_utilisateur
  ";

  public function __construct($db) {
    $this->db = $db;
  }

  public function getAll() {
      $stmt = $this->db->query(self::$FETCH_ALL_QUERY . " ORDER BY b.date_creation DESC");
      return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getLasts($limit = 3) {
    $stmt = $this->db->prepare(self::$FETCH_ALL_QUERY . "ORDER BY b.date_creation DESC LIMIT ?");
    $stmt->bindValue(1, (int)$limit, PDO::PARAM_INT); // le paramètre doit être un entier
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getById($id) {
    $stmt = $this->db->prepare(self::$FETCH_ALL_QUERY . " WHERE b.id_billet = ?");
    $stmt->bindValue(1, (int)$id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function create($data) {
    $stmt = $this->db->prepare("INSERT INTO billets (titre, contenu, id_utilisateur) VALUES (?, ?, ?)");
    $stmt->execute([$data['titre'], $data['contenu'], $data['id_utilisateur']]);
  }

  public function update($id, $data) {
    if ($id == NULL) {
      return $this->create($data);
    }
    $stmt = $this->db->prepare("UPDATE billets SET titre = ?, contenu = ? WHERE id_billet = ?");
    $stmt->execute([$data['titre'], $data['contenu'], $id]);
  }

  public function delete($id) {
    $stmt = $this->db->prepare("DELETE FROM billets WHERE id_billet = ?");
    $stmt->execute([$id]);
  }
}
