<?php

class Comment {
  private $db;

  public function __construct($db) {
    $this->db = $db;
  }

  public function getAll() {
    $stmt = $this->db->query("SELECT * FROM commentaires");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getAllForArticle($id) {
    $stmt = $this->db->prepare("
      SELECT c.*, u.id_utilisateur, u.login, u.nom, u.prenom FROM commentaires c
      LEFT JOIN utilisateurs u ON c.id_utilisateur = u.id_utilisateur
      WHERE c.id_billet = ?
    ");
    $stmt->execute([$id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }

  public function getById($id) {
    $stmt = $this->db->prepare("
      SELECT c.*, u.id_utilisateur, u.login, u.nom, u.prenom FROM commentaires c
      LEFT JOIN utilisateurs u ON c.id_utilisateur = u.id_utilisateur
      WHERE c.id_commentaire = ?
    ");
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function create($data) {
    $stmt = $this->db->prepare("INSERT INTO commentaires (contenu, id_utilisateur, id_billet) VALUES (?, ?, ?)");
    $stmt->execute([$data['contenu'], $data['id_utilisateur'], $data['id_billet']]);
    return $this->db->lastInsertId();
  }

  public function update($id, $data) {
    $stmt = $this->db->prepare("UPDATE commentaires SET contenu = ? WHERE id_commentaire = ?");
    $stmt->execute([$data['contenu'], $id]);
  }

  public function delete($id) {
    $stmt = $this->db->prepare("DELETE FROM commentaires WHERE id_commentaire = ?");
    $stmt->execute([$id]);
  }
}
