<?php

class User {
    private $db;

    public function __construct($db) {
        $this->db = $db;
    }

    public function getAll() {
        $stmt = $this->db->query("SELECT * FROM utilisateurs");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM utilisateurs WHERE id_utilisateur = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getByLogin($login) {
        $stmt = $this->db->prepare("SELECT * FROM utilisateurs WHERE login = ?");
        $stmt->execute([$login]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data, $photo = NULL) {
        $admin = isset($data['admin']) ? 1 : 0;
        $stmt = $this->db->prepare("INSERT INTO utilisateurs (login, mdp, nom, prenom, photo, admin) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$data['login'], password_hash($data['mdp'], PASSWORD_DEFAULT), $data['nom'], $data['prenom'], $photo, $admin]);
        return $this->db->lastInsertId();
    }

    public function update($id, $data) {
        if ($id == NULL) {
          return $this->create($data);
        }
        $admin = isset($data['admin']) ? 1 : 0;
        $stmt = $this->db->prepare("UPDATE utilisateurs SET login = ?, nom = ?, prenom = ?, admin = ? WHERE id_utilisateur = ?");
        $stmt->execute([$data['login'], $data['nom'], $data['prenom'], $admin, $id]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM utilisateurs WHERE id_utilisateur = ?");
        $stmt->execute([$id]);
    }
}
