<!DOCTYPE html>
    <html lang="fr">
    <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title><?php echo $title; ?></title>
      <link rel="stylesheet" href="styles.css">
      <script src="https://cdn.jsdelivr.net/npm/handlebars@latest/dist/handlebars.min.js"></script>
      <script src="js/comments.js" defer></script>
    </head>
    <body>
        <header>
            <nav>
                <ul>
                  <?php if ($loggedUser != NULL): ?>
                    <li>
                      <div class="user">
                        <?php if (!empty($loggedUser["photo"])): ?>
                          <img src="<?php echo $loggedUser["photo"]; ?>" alt="User Photo" class="user-photo">
                        <?php endif; ?>
                        <p><?php echo $loggedUser["login"]; ?></p>
                      </div>
                    </li>
                  <?php endif; ?>
                  <li><a href="index.php">Accueil</a></li>
                  <li><a href="index.php?page=articles&action=archives">Archives</a></li>
                  <?php if ($loggedUser != NULL): ?>
                      <?php if ($loggedUser["admin"] != 0): ?>
                          <li><a href="index.php?page=admin">Administration</a></li>
                      <?php endif; ?>
                  <li class ="connexion"><a href="index.php?page=users&action=logout">Déconnexion</a></li>
                  <?php else: ?>
                      <li><a href="index.php?page=users&action=register">Inscription</a></li>
                      <li class ="connexion"><a href="index.php?page=users&action=login">Connexion</a></li>
                  <?php endif; ?>
                </ul>
            </nav>
        </header>
        <main>
