<?php

session_start();

require 'includes/config/bdd.php';

require 'includes/controllers/users.php';
require 'includes/controllers/articles.php';
require 'includes/controllers/comments.php';
require 'includes/controllers/admin.php';

$usersController = new UsersController($db);
$articleController = new ArticlesController($db);
$commentsController = new CommentsController($db);
$adminController = new AdminController($db);

$controllers = [
    'users' => $usersController,
    'articles' => $articleController,
    'comments' => $commentsController,
    'admin' => $adminController
];

$page = $_GET['page'] ?? 'articles';
$action = $_GET['action'] ?? 'list';

if (isset($controllers[$page])) {
    $controller = $controllers[$page];
    if (method_exists($controller, $action)) {
        $controller->$action($_GET['id'] ?? NULL);
    } else {
        echo 'Action inconnue: ' . $action;
    }
} else {
    echo 'Page inconnue: ' . $page;
}

?>
