class CommentsSection {
  constructor(parentElement, articleId, userId) {
    this.parentElement = parentElement;
    this.articleId = articleId;
    this.comments = [];
    this.userId = userId;
    this.template = null;
    this.display = 'hidden';
    this.init();
  }

  async init() {
    await this.loadTemplate();
    this.render();
    this.addListeners();
  }

  async loadTemplate() {
    const response = await fetch('js/comments.hbs');
    const texte = await response.text();
    this.template = Handlebars.compile(texte);
  }

  render() {
    const html = this.template({
      display: this.display,
      comments: this.comments,
      has_comments: this.comments.length > 0,
      articleId: this.articleId,
      userId: this.userId,
    });
    this.parentElement.innerHTML = html;
  }

  addListeners() {
    this.parentElement.querySelector('#comments_btn').addEventListener('click', async () => {
      const section = this.parentElement.querySelector('.comments');
      if (this.display === 'hidden') {
        this.display = '';
        const response = await fetch(`index.php?page=comments&action=json_list&id=${this.articleId}`)
        this.comments = await response.json();
        this.render();
        this.addListeners(); // Re-add event listeners after re-rendering
      } else {
        this.display = 'hidden';
        this.render();
        this.addListeners();
      }
    });

    const btnAjouter = this.parentElement.querySelector('#add_comment_btn');
    if (btnAjouter) {
      btnAjouter.addEventListener('click', () => {
        this.parentElement.querySelector('.create').classList.toggle('hidden');
      });
    }

    this.parentElement.querySelector('#comment_form').addEventListener('submit', (e) => {
      e.preventDefault();
      this.ajouteCommentaire();
    });
  }

  async ajouteCommentaire() {
    const form = this.parentElement.querySelector('#comment_form');
    const formData = new FormData(form);

    const response = await fetch('index.php?page=comments&action=json_add', {
      method: 'POST',
      body: formData
    });

    // Simulate adding a comment (you would typically send this to the server)
    const comment = await response.json();

    this.comments.push(comment);
    this.render();
    this.addListeners(); // Re-add event listeners after re-rendering
  }
}